<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Name: eHDSI Patient Medication Instructions
Description: 
                 Any medication may be the subject of further instructions to the patient, for example to indicate that it should be taken with food, etc.  
                 This structure is included in the target supply act using the <entryRelationship> element defined in the CDA Schema. The example below shows the recording of patient medication instruction for an <entry>, and is used as context for the following section.  
                   
                 
                     Act classCode 
                 
                   
                 
                     <act classCode="ACT"moodCode="INT"> 
                 
                   
                 The related statement is the intent (moodCode='INT') on how the related entry is to be performed.  
                   
                 
                     Template Id root 
                 
                   
                 
                     <templateId root="1.3.6.1.4.1.12559.11.10.1.3.1.3.12"/> 
              
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024">
   <title>eHDSI Patient Medication Instructions</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]
Item: (eHDSI Patient Medication Instructions)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]
Item: (eHDSI Patient Medication Instructions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]"
         id="d45e20144-false-d246297e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="string(@classCode) = ('ACT')">(eHDSI Patient Medication Instructions): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="string(@moodCode) = ('INT')">(eHDSI Patient Medication Instructions): The value for moodCode SHALL be 'INT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12']) &gt;= 1">(eHDSI Patient Medication Instructions): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12']) &lt;= 1">(eHDSI Patient Medication Instructions): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.3']) &lt;= 1">(eHDSI Patient Medication Instructions): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.3'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']) &gt;= 1">(eHDSI Patient Medication Instructions): element hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49'] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']) &lt;= 1">(eHDSI Patient Medication Instructions): element hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:code[(@code = 'PINSTRUCT' and @codeSystem = '1.3.6.1.4.1.19376.1.5.3.2') or @nullFlavor]) &gt;= 1">(eHDSI Patient Medication Instructions): element hl7:code[(@code = 'PINSTRUCT' and @codeSystem = '1.3.6.1.4.1.19376.1.5.3.2') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:code[(@code = 'PINSTRUCT' and @codeSystem = '1.3.6.1.4.1.19376.1.5.3.2') or @nullFlavor]) &lt;= 1">(eHDSI Patient Medication Instructions): element hl7:code[(@code = 'PINSTRUCT' and @codeSystem = '1.3.6.1.4.1.19376.1.5.3.2') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:text) &lt;= 1">(eHDSI Patient Medication Instructions): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(eHDSI Patient Medication Instructions): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12']
Item: (eHDSI Patient Medication Instructions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12']"
         id="d45e20150-false-d246361e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Patient Medication Instructions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.3.12')">(eHDSI Patient Medication Instructions): The value for root SHALL be '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.3']
Item: (eHDSI Patient Medication Instructions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.3']"
         id="d45e20161-false-d246376e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.5.3.1.4.3')">(eHDSI Patient Medication Instructions): The value for root SHALL be '1.3.6.1.4.1.19376.1.5.3.1.4.3'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']
Item: (eHDSI Patient Medication Instructions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']"
         id="d45e20172-false-d246388e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Patient Medication Instructions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.1.49')">(eHDSI Patient Medication Instructions): The value for root SHALL be '2.16.840.1.113883.10.20.1.49'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:code[(@code = 'PINSTRUCT' and @codeSystem = '1.3.6.1.4.1.19376.1.5.3.2') or @nullFlavor]
Item: (eHDSI Patient Medication Instructions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:code[(@code = 'PINSTRUCT' and @codeSystem = '1.3.6.1.4.1.19376.1.5.3.2') or @nullFlavor]"
         id="d45e20184-false-d246403e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Patient Medication Instructions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="@nullFlavor or (@code='PINSTRUCT' and @codeSystem='1.3.6.1.4.1.19376.1.5.3.2')">(eHDSI Patient Medication Instructions): The element value SHALL be one of 'code 'PINSTRUCT' codeSystem '1.3.6.1.4.1.19376.1.5.3.2''.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:text
Item: (eHDSI Patient Medication Instructions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:text"
         id="d45e20189-false-d246419e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(eHDSI Patient Medication Instructions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ED". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(eHDSI Patient Medication Instructions): element hl7:reference[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(eHDSI Patient Medication Instructions): element hl7:reference[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:text/hl7:reference[not(@nullFlavor)]
Item: (eHDSI Patient Medication Instructions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:text/hl7:reference[not(@nullFlavor)]"
         id="d45e20191-false-d246438e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(eHDSI Patient Medication Instructions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TEL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="@value">(eHDSI Patient Medication Instructions): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.12
Context: *[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (eHDSI Patient Medication Instructions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]]/hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.12'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.49']]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d45e20201-false-d246453e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(eHDSI Patient Medication Instructions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.12-2023-07-03T134024.html"
              test="@nullFlavor or (@code='completed')">(eHDSI Patient Medication Instructions): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>
</pattern>
