<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Name: epSOS CDA Supply
Description: Dispensed Medicine Entry Content Module
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844">
   <title>epSOS CDA Supply</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]"
         id="d45e46386-false-d371651e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]) &gt;= 1">(epSOS CDA Supply): element hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]) &lt;= 1">(epSOS CDA Supply): element hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]"
         id="d45e46482-false-d371742e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@classCode) = ('SPLY')">(epSOS CDA Supply): The value for classCode SHALL be 'SPLY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@moodCode) = ('EVN')">(epSOS CDA Supply): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@moodCode),'\s'))"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="not(@moodCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19461-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(epSOS CDA Supply): The value for moodCode SHALL be selected from value set '2.16.840.1.113883.1.11.19461' x_DocumentSubstanceMood (DYNAMIC).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34']) &gt;= 1">(epSOS CDA Supply): element hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34']) &lt;= 1">(epSOS CDA Supply): element hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3']) &gt;= 1">(epSOS CDA Supply): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3']) &lt;= 1">(epSOS CDA Supply): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']) &gt;= 1">(epSOS CDA Supply): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']) &lt;= 1">(epSOS CDA Supply): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(epSOS CDA Supply): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(epSOS CDA Supply): element hl7:id[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:quantity[not(@nullFlavor)]) &gt;= 1">(epSOS CDA Supply): element hl7:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:quantity[not(@nullFlavor)]) &lt;= 1">(epSOS CDA Supply): element hl7:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]) &gt;= 1">(epSOS CDA Supply): element hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]) &lt;= 1">(epSOS CDA Supply): element hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:performer[hl7:assignedEntity]) &gt;= 1">(epSOS CDA Supply): element hl7:performer[hl7:assignedEntity] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:performer[hl7:assignedEntity]) &lt;= 1">(epSOS CDA Supply): element hl7:performer[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]) &gt;= 1">(epSOS CDA Supply): element hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]) &lt;= 1">(epSOS CDA Supply): element hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]]) &lt;= 1">(epSOS CDA Supply): element hl7:entryRelationship[hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34']
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34']"
         id="d45e46497-false-d371889e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(epSOS CDA Supply): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.1.34')">(epSOS CDA Supply): The value for root SHALL be '2.16.840.1.113883.10.20.1.34'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3']
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3']"
         id="d45e46502-false-d371904e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(epSOS CDA Supply): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.5.3.1.4.7.3')">(epSOS CDA Supply): The value for root SHALL be '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']"
         id="d45e46508-false-d371919e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(epSOS CDA Supply): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.3.3')">(epSOS CDA Supply): The value for root SHALL be '1.3.6.1.4.1.12559.11.10.1.3.1.3.3'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:id[not(@nullFlavor)]
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:id[not(@nullFlavor)]"
         id="d45e46513-false-d371933e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(epSOS CDA Supply): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:quantity[not(@nullFlavor)]
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:quantity[not(@nullFlavor)]"
         id="d45e46519-false-d371943e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(epSOS CDA Supply): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(epSOS CDA Supply): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(epSOS CDA Supply): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]
Item: (epSOS CDA Supply)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]">
      <extends rule="d371973e0-false-d371977e0"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@typeCode) = ('PRD') or not(@typeCode)">(epSOS CDA Supply): The value for typeCode SHALL be 'PRD'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.1
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]
Item: (eHDSI Manufactured Product)
-->
   <rule fpi="RULC-1" id="d371973e0-false-d371977e0" abstract="true">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="count(hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]) &lt;= 1">(eHDSI Manufactured Product): element hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.1
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]
Item: (eHDSI Manufactured Product)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="string(@classCode) = ('MANU') or not(@classCode)">(eHDSI Manufactured Product): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']) &gt;= 1">(eHDSI Manufactured Product): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']) &lt;= 1">(eHDSI Manufactured Product): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="count(hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI Manufactured Product): element hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="count(hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI Manufactured Product): element hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="count(epsos:marketingAuthorizationHolder) &lt;= 1">(eHDSI Manufactured Product): element epsos:marketingAuthorizationHolder appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.1
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']
Item: (eHDSI Manufactured Product)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Manufactured Product): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.3.1')">(eHDSI Manufactured Product): The value for root SHALL be '1.3.6.1.4.1.12559.11.10.1.3.1.3.1'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.1
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:templateId
Item: (eHDSI Manufactured Product)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:templateId">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Manufactured Product): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@classCode) = ('MMAT')">(eHDSI Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(hl7:code) &lt;= 1">(eHDSI Material): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(hl7:name) &lt;= 1">(eHDSI Material): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:desc) &lt;= 1">(eHDSI Material): element epsos:desc appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI Material): element epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Material): element epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI Material): element epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:asSpecializedKind[@classCode = 'GEN']) &lt;= 1">(eHDSI Material): element epsos:asSpecializedKind[@classCode = 'GEN'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:code
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name">
      <extends rule="EN"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:EN". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:desc
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:desc">
      <extends rule="EN"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:EN". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.2 eHDSIDoseForm (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@classCode) = ('CONT')">(eHDSI Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI Material): element epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI Material): element epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]/epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]/epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@classCode) = ('CONT')">(eHDSI Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI Material): element epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Material): element epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:capacityQuantity[not(@nullFlavor)]) &gt;= 1">(eHDSI Material): element epsos:capacityQuantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:capacityQuantity[not(@nullFlavor)]) &lt;= 1">(eHDSI Material): element epsos:capacityQuantity[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]/epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:name
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]/epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]/epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]/epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.2 eHDSIDoseForm (DYNAMIC) or 1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]/epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:capacityQuantity[not(@nullFlavor)]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asContent[@classCode = 'CONT'][epsos:containerPackagedMedicine[@classCode = 'CONT'][@determinerCode = 'KIND']]/epsos:containerPackagedMedicine[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:capacityQuantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@unit">(eHDSI Material): attribute @unit SHALL be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI Material): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@value">(eHDSI Material): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asSpecializedKind[@classCode = 'GEN']
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asSpecializedKind[@classCode = 'GEN']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@classCode) = ('GEN')">(eHDSI Material): The value for classCode SHALL be 'GEN'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asSpecializedKind[@classCode = 'GEN']/epsos:generalizedMedicineClass[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asSpecializedKind[@classCode = 'GEN']/epsos:generalizedMedicineClass[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@classCode) = ('MMAT')">(eHDSI Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI Material): element epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Material): element epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:name) &lt;= 1">(eHDSI Material): element epsos:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asSpecializedKind[@classCode = 'GEN']/epsos:generalizedMedicineClass[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asSpecializedKind[@classCode = 'GEN']/epsos:generalizedMedicineClass[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.24 eHDSIActiveIngredient (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:asSpecializedKind[@classCode = 'GEN']/epsos:generalizedMedicineClass[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:name
Item: (eHDSI Material)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@classCode) = ('ACTI')">(eHDSI Material): The value for classCode SHALL be 'ACTI'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI Material): element epsos:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI Material): element epsos:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI Material): element epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI Material): element epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:quantity[not(@nullFlavor)]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:quantity[not(@nullFlavor)]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:numerator) &gt;= 1">(eHDSI Material): element epsos:numerator is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:numerator) &lt;= 1">(eHDSI Material): element epsos:numerator appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:denominator) &gt;= 1">(eHDSI Material): element epsos:denominator is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:denominator) &lt;= 1">(eHDSI Material): element epsos:denominator appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:quantity[not(@nullFlavor)]/epsos:numerator
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:quantity[not(@nullFlavor)]/epsos:numerator">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:epsos-org:ep:medication', 'PQ')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:epsos-org:ep:medication}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@unit">(eHDSI Material): attribute @unit SHALL be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI Material): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@value">(eHDSI Material): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:quantity[not(@nullFlavor)]/epsos:denominator
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:quantity[not(@nullFlavor)]/epsos:denominator">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:epsos-org:ep:medication', 'PQ')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:epsos-org:ep:medication}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@unit">(eHDSI Material): attribute @unit SHALL be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI Material): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@value">(eHDSI Material): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@classCode) = ('MMAT')">(eHDSI Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI Material): element epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Material): element epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="count(epsos:name) &lt;= 1">(eHDSI Material): element epsos:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.24 eHDSIActiveIngredient (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/epsos:originalText
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/epsos:originalText">
      <extends rule="ED"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ED". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/epsos:originalText/epsos:reference
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/epsos:originalText/epsos:reference">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TEL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/epsos:translation
Item: (eHDSI Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/epsos:translation">
      <extends rule="CD"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.143-2021-12-17T100849.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.143
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/hl7:manufacturedMaterial[epsos:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:ingredient[epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/epsos:ingredient[epsos:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/epsos:name
Item: (eHDSI Material)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.1
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/epsos:marketingAuthorizationHolder
Item: (eHDSI Manufactured Product)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/epsos:marketingAuthorizationHolder">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(eHDSI Manufactured Product): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(eHDSI Manufactured Product): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="@nullFlavor or epsos:id or epsos:name">(eHDSI Manufactured Product): If the MarketingAuthorizationHolder element is specified and doesn't have a nullFlavor value, an id or name element has to present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="count(epsos:name) &lt;= 1">(eHDSI Manufactured Product): element epsos:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.1
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/epsos:marketingAuthorizationHolder/epsos:id
Item: (eHDSI Manufactured Product)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/epsos:marketingAuthorizationHolder/epsos:id">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Manufactured Product): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.1
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/epsos:marketingAuthorizationHolder/epsos:name
Item: (eHDSI Manufactured Product)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:product[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.1']]/epsos:marketingAuthorizationHolder/epsos:name">
      <extends rule="ON"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.1-2020-09-09T141335.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(eHDSI Manufactured Product): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ON". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]
Item: (epSOS CDA Supply)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.136
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]
Item: (eHDSI Performer (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.136-2020-04-16T123315.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(eHDSI Performer (Body)): The value for typeCode SHALL be 'PRF'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.136-2020-04-16T123315.html"
              test="count(hl7:time) &lt;= 1">(eHDSI Performer (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.136-2020-04-16T123315.html"
              test="count(hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Performer (Body)): element hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.136-2020-04-16T123315.html"
              test="count(hl7:assignedEntity) &gt;= 1">(eHDSI Performer (Body)): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.136-2020-04-16T123315.html"
              test="count(hl7:assignedEntity) &lt;= 1">(eHDSI Performer (Body)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.136
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:time
Item: (eHDSI Performer (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:time">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.136-2020-04-16T123315.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(eHDSI Performer (Body)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:IVL_TS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.136
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Performer (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.136-2020-04-16T123315.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Performer (Body)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.136-2020-04-16T123315.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Performer (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.16543 ParticipationMode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.136
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity
Item: (eHDSI Performer (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.114
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity
Item: (eHDSI AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(eHDSI AssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="count(hl7:id) &gt;= 1">(eHDSI AssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.111' or @nullFlavor]) &lt;= 1">(eHDSI AssignedEntity): element hl7:code[@codeSystem = '2.16.840.1.113883.5.111' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="count(hl7:addr) &gt;= 1">(eHDSI AssignedEntity): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="count(hl7:telecom) &gt;= 1">(eHDSI AssignedEntity): element hl7:telecom is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="count(hl7:assignedPerson) &lt;= 1">(eHDSI AssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="count(hl7:representedOrganization) &lt;= 1">(eHDSI AssignedEntity): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.114
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (eHDSI AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI AssignedEntity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.114
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code[@codeSystem = '2.16.840.1.113883.5.111' or @nullFlavor]
Item: (eHDSI AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code[@codeSystem = '2.16.840.1.113883.5.111' or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI AssignedEntity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.5.111')">(eHDSI AssignedEntity): The element value SHALL be one of 'codeSystem '2.16.840.1.113883.5.111''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.114
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (eHDSI AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="AD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(eHDSI AssignedEntity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:AD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.114
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (eHDSI AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <extends rule="TEL.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.114-2020-04-16T105133.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(eHDSI AssignedEntity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TEL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.114
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (eHDSI AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.113
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (eHDSI Person)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.113-2020-04-16T105053.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(eHDSI Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.113-2020-04-16T105053.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(eHDSI Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.113-2020-04-16T105053.html"
              test="count(hl7:name) &gt;= 1">(eHDSI Person): element hl7:name is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.113
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (eHDSI Person)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <extends rule="PN"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.113-2020-04-16T105053.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(eHDSI Person): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PN". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.114
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (eHDSI AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (eHDSI Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(eHDSI Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(eHDSI Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:id) &gt;= 1">(eHDSI Organization): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:id) &lt;= 1">(eHDSI Organization): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:name) &gt;= 1">(eHDSI Organization): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:name) &lt;= 1">(eHDSI Organization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:telecom) &gt;= 1">(eHDSI Organization): element hl7:telecom is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:addr[hl7:country]) &gt;= 1">(eHDSI Organization): element hl7:addr[hl7:country] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:addr[hl7:country]) &lt;= 1">(eHDSI Organization): element hl7:addr[hl7:country] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (eHDSI Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:id">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(eHDSI Organization): Attribute @nullFlavor SHALL be of data type 'cs'  - '<value-of select="@nullFlavor"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (eHDSI Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:name">
      <extends rule="ON"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(eHDSI Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ON". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(eHDSI Organization): Attribute @nullFlavor SHALL be of data type 'cs'  - '<value-of select="@nullFlavor"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (eHDSI Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(eHDSI Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TEL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.40-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(eHDSI Organization): The value for use SHALL be selected from value set '1.3.6.1.4.1.12559.11.10.1.3.1.42.40' eHDSITelecomAddress (DYNAMIC).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(eHDSI Organization): The value for nullFlavor SHALL be 'NI'. Found: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr[hl7:country]
Item: (eHDSI Organization)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr[hl7:country]">
      <extends rule="AD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(eHDSI Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:AD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="@nullFlavor or hl7:*">(eHDSI Organization): If addr is not nullflavored at least one sub element has to be provided</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:city) &lt;= 1">(eHDSI Organization): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:postalCode) &lt;= 1">(eHDSI Organization): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:state) &lt;= 1">(eHDSI Organization): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:country) &gt;= 1">(eHDSI Organization): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.111-2020-10-07T094007.html"
              test="count(hl7:country) &lt;= 1">(eHDSI Organization): element hl7:country appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr[hl7:country]/hl7:streetAddressLine
Item: (eHDSI Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr[hl7:country]/hl7:city
Item: (eHDSI Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr[hl7:country]/hl7:postalCode
Item: (eHDSI Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr[hl7:country]/hl7:state
Item: (eHDSI Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.111
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr[hl7:country]/hl7:country
Item: (eHDSI Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]"
         id="d372690e279-false-d373182e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="@typeCode">(eHDSI Dispenser Credentialing Organization): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(eHDSI Dispenser Credentialing Organization): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="string(@contextControlCode) = ('OP')">(eHDSI Dispenser Credentialing Organization): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="count(hl7:time) &lt;= 1">(eHDSI Dispenser Credentialing Organization): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Dispenser Credentialing Organization): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="count(hl7:participantRole) &gt;= 1">(eHDSI Dispenser Credentialing Organization): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="count(hl7:participantRole) &lt;= 1">(eHDSI Dispenser Credentialing Organization): element hl7:participantRole appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:time
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:time"
         id="d372690e288-false-d373232e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(eHDSI Dispenser Credentialing Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:IVL_TS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d372690e290-false-d373245e0">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Dispenser Credentialing Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Dispenser Credentialing Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole"
         id="d372690e295-false-d373265e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="string(@classCode) = ('LIC') or not(@classCode)">(eHDSI Dispenser Credentialing Organization): The value for classCode SHALL be 'LIC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.111' or @nullFlavor]) &lt;= 1">(eHDSI Dispenser Credentialing Organization): element hl7:code[@codeSystem = '2.16.840.1.113883.5.111' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="count(hl7:scopingEntity) &lt;= 1">(eHDSI Dispenser Credentialing Organization): element hl7:scopingEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:id
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:id"
         id="d372690e299-false-d373302e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Dispenser Credentialing Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:code[@codeSystem = '2.16.840.1.113883.5.111' or @nullFlavor]
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:code[@codeSystem = '2.16.840.1.113883.5.111' or @nullFlavor]"
         id="d372690e301-false-d373313e0">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Dispenser Credentialing Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.5.111')">(eHDSI Dispenser Credentialing Organization): The element value SHALL be one of 'codeSystem '2.16.840.1.113883.5.111''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:addr
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:addr"
         id="d372690e306-false-d373329e0">
      <extends rule="AD"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(eHDSI Dispenser Credentialing Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:AD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:telecom
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:telecom"
         id="d372690e308-false-d373339e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(eHDSI Dispenser Credentialing Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TEL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity"
         id="d372690e311-false-d373349e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(eHDSI Dispenser Credentialing Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(eHDSI Dispenser Credentialing Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="count(hl7:code) &lt;= 1">(eHDSI Dispenser Credentialing Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="count(hl7:desc) &lt;= 1">(eHDSI Dispenser Credentialing Organization): element hl7:desc appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:id
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:id"
         id="d372690e317-false-d373384e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Dispenser Credentialing Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:code
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:code"
         id="d372690e319-false-d373397e0">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Dispenser Credentialing Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(eHDSI Dispenser Credentialing Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.149
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:desc
Item: (eHDSI Dispenser Credentialing Organization)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:participantRole]/hl7:participantRole/hl7:scopingEntity/hl7:desc"
         id="d372690e324-false-d373417e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.149-2020-04-16T123528.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(eHDSI Dispenser Credentialing Organization): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ED". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]
Item: (epSOS CDA Supply)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]">
      <extends rule="d373445e0-false-d373449e0"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@typeCode) = ('REFR')">(epSOS CDA Supply): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.144
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]
Item: (eHDSI Related Prescription)
-->
   <rule fpi="RULC-1" id="d373445e0-false-d373449e0" abstract="true">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.144-2024-04-15T094040.html"
              test="count(hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]) &gt;= 1">(eHDSI Related Prescription): element hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.144-2024-04-15T094040.html"
              test="count(hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]) &lt;= 1">(eHDSI Related Prescription): element hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.144
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]
Item: (eHDSI Related Prescription)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.144-2024-04-15T094040.html"
              test="string(@classCode) = ('SBADM')">(eHDSI Related Prescription): The value for classCode SHALL be 'SBADM'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.144-2024-04-15T094040.html"
              test="string(@moodCode) = ('INT')">(eHDSI Related Prescription): The value for moodCode SHALL be 'INT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.144-2024-04-15T094040.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(eHDSI Related Prescription): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.144-2024-04-15T094040.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(eHDSI Related Prescription): element hl7:id[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.144-2024-04-15T094040.html"
              test="count(hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]) &gt;= 1">(eHDSI Related Prescription): element hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.144-2024-04-15T094040.html"
              test="count(hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]) &lt;= 1">(eHDSI Related Prescription): element hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.144
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:id[not(@nullFlavor)]
Item: (eHDSI Related Prescription)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:id[not(@nullFlavor)]">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.144-2024-04-15T094040.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Related Prescription): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.144
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]
Item: (eHDSI Related Prescription)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.29
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]
Item: (eHDSI eP/eD Medication Information)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="count(hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]) &lt;= 1">(eHDSI eP/eD Medication Information): element hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.29
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]
Item: (eHDSI eP/eD Medication Information)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="string(@classCode) = ('MANU') or not(@classCode)">(eHDSI eP/eD Medication Information): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']) &gt;= 1">(eHDSI eP/eD Medication Information): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29'] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']) &lt;= 1">(eHDSI eP/eD Medication Information): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="count(hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]) &gt;= 1">(eHDSI eP/eD Medication Information): element hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="count(hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]) &lt;= 1">(eHDSI eP/eD Medication Information): element hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="count(hl7:manufacturerOrganization) &lt;= 1">(eHDSI eP/eD Medication Information): element hl7:manufacturerOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.29
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']
Item: (eHDSI eP/eD Medication Information)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI eP/eD Medication Information): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.3.29')">(eHDSI eP/eD Medication Information): The value for root SHALL be '1.3.6.1.4.1.12559.11.10.1.3.1.3.29'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('MMAT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']) &gt;= 1">(eHDSI eP/eD Manufactured Material): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']) &lt;= 1">(eHDSI eP/eD Manufactured Material): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(hl7:code) &lt;= 1">(eHDSI eP/eD Manufactured Material): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(hl7:name) &gt;= 1">(eHDSI eP/eD Manufactured Material): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(hl7:name) &lt;= 1">(eHDSI eP/eD Manufactured Material): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:desc) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:desc appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:asSpecializedKind[generalizedMaterialKind/code/@codeSystem='2.16.840.1.113883.6.73']) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:asSpecializedKind[generalizedMaterialKind/code/@codeSystem='2.16.840.1.113883.6.73'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.3.30')">(eHDSI eP/eD Manufactured Material): The value for root SHALL be '1.3.6.1.4.1.12559.11.10.1.3.1.3.30'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:name
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:name">
      <extends rule="EN"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:EN". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:desc
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:desc">
      <extends rule="EN"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:EN". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI eP/eD Manufactured Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.2 eHDSIDoseForm (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('CONT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI eP/eD Manufactured Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI eP/eD Manufactured Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI eP/eD Manufactured Material): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@value">(eHDSI eP/eD Manufactured Material): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('CONT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI eP/eD Manufactured Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('CONT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI eP/eD Manufactured Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI eP/eD Manufactured Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI eP/eD Manufactured Material): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@value">(eHDSI eP/eD Manufactured Material): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('CONT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI eP/eD Manufactured Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('CONT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI eP/eD Manufactured Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI eP/eD Manufactured Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI eP/eD Manufactured Material): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@value">(eHDSI eP/eD Manufactured Material): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('CONT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI eP/eD Manufactured Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[generalizedMaterialKind/code/@codeSystem='2.16.840.1.113883.6.73']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[generalizedMaterialKind/code/@codeSystem='2.16.840.1.113883.6.73']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('GRIC')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'GRIC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:generalizedMaterialKind[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:generalizedMaterialKind[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:generalizedMaterialKind[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:generalizedMaterialKind[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[generalizedMaterialKind/code/@codeSystem='2.16.840.1.113883.6.73']/pharm:generalizedMaterialKind[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[generalizedMaterialKind/code/@codeSystem='2.16.840.1.113883.6.73']/pharm:generalizedMaterialKind[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('MMAT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:name) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[generalizedMaterialKind/code/@codeSystem='2.16.840.1.113883.6.73']/pharm:generalizedMaterialKind[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[generalizedMaterialKind/code/@codeSystem='2.16.840.1.113883.6.73']/pharm:generalizedMaterialKind[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI eP/eD Manufactured Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.24 eHDSIActiveIngredient (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[generalizedMaterialKind/code/@codeSystem='2.16.840.1.113883.6.73']/pharm:generalizedMaterialKind[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI eP/eD Manufactured Material)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[@classCode = 'GEN'][pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[@classCode = 'GEN'][pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('GEN')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'GEN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:generalizedMaterialKind[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:generalizedMaterialKind[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:generalizedMaterialKind[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:generalizedMaterialKind[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[@classCode = 'GEN'][pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:generalizedMaterialKind[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[@classCode = 'GEN'][pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:generalizedMaterialKind[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('MMAT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[@classCode = 'GEN'][pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:generalizedMaterialKind[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[@classCode = 'GEN'][pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:generalizedMaterialKind[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asSpecializedKind[@classCode = 'GEN'][pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:generalizedMaterialKind[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:name
Item: (eHDSI eP/eD Manufactured Material)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('PART')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:id) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND'] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:id
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:id">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:quantity
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:quantity">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI eP/eD Manufactured Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI eP/eD Manufactured Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('MMAT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:name) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:desc) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:desc appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code">
      <extends rule="CE"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:name
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:name">
      <extends rule="EN"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:EN". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:desc
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:desc">
      <extends rule="ED"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ED". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI eP/eD Manufactured Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.2 eHDSIDoseForm (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('CONT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI asContent): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI asContent): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI asContent): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@value">(eHDSI asContent): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asContent): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:code) &lt;= 1">(eHDSI asContent): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI asContent): element pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI asContent): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI asContent): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI asContent): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI asContent): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@value">(eHDSI asContent): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asContent): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:code) &lt;= 1">(eHDSI asContent): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI asContent): element pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI asContent): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI asContent): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI asContent): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI asContent): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@value">(eHDSI asContent): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asContent): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:code) &lt;= 1">(eHDSI asContent): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI asContent): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('GRIC')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'GRIC'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.36
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]
Item: (eHDSI asSpecializedKind)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asSpecializedKind): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="string(@classCode) = ('MMAT')">(eHDSI asSpecializedKind): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="count(hl7:code) &gt;= 1">(eHDSI asSpecializedKind): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="count(hl7:code) &lt;= 1">(eHDSI asSpecializedKind): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.36
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]/hl7:code
Item: (eHDSI asSpecializedKind)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.36
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]/hl7:name
Item: (eHDSI asSpecializedKind)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('PART')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:id) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND'] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:id
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:id">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:quantity
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:quantity">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI eP/eD Manufactured Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI eP/eD Manufactured Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('MMAT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:name) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:desc) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:desc appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code">
      <extends rule="CE"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:name
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:name">
      <extends rule="EN"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:EN". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:desc
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:desc">
      <extends rule="ED"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ED". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI eP/eD Manufactured Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.2 eHDSIDoseForm (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('CONT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI asContent): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI asContent): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI asContent): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@value">(eHDSI asContent): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asContent): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:code) &lt;= 1">(eHDSI asContent): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI asContent): element pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI asContent): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI asContent): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI asContent): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI asContent): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@value">(eHDSI asContent): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asContent): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:code) &lt;= 1">(eHDSI asContent): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI asContent): element pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI asContent): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI asContent): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI asContent): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI asContent): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@value">(eHDSI asContent): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asContent): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:code) &lt;= 1">(eHDSI asContent): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI asContent): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('GRIC')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'GRIC'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.36
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]
Item: (eHDSI asSpecializedKind)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asSpecializedKind): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="string(@classCode) = ('MMAT')">(eHDSI asSpecializedKind): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="count(hl7:code) &gt;= 1">(eHDSI asSpecializedKind): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="count(hl7:code) &lt;= 1">(eHDSI asSpecializedKind): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.36
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]/hl7:code
Item: (eHDSI asSpecializedKind)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.36
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]/hl7:name
Item: (eHDSI asSpecializedKind)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('PART')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:id) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND'] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:id
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:id">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:quantity
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:quantity">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI eP/eD Manufactured Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI eP/eD Manufactured Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('MMAT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:name) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:desc) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:desc appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code">
      <extends rule="CE"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:name
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:name">
      <extends rule="EN"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:EN". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:desc
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:desc">
      <extends rule="ED"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ED". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.2-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI eP/eD Manufactured Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.2 eHDSIDoseForm (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('CONT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI asContent): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI asContent): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI asContent): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@value">(eHDSI asContent): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asContent): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:code) &lt;= 1">(eHDSI asContent): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI asContent): element pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI asContent): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI asContent): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI asContent): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI asContent): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@value">(eHDSI asContent): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asContent): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:code) &lt;= 1">(eHDSI asContent): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(eHDSI asContent): element pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI asContent): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI asContent): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI asContent): element pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI asContent): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI asContent): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI asContent): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@value">(eHDSI asContent): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@classCode) = ('CONT')">(eHDSI asContent): The value for classCode SHALL be 'CONT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asContent): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:code) &lt;= 1">(eHDSI asContent): element pharm:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="count(pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI asContent): element pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.38
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI asContent)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:asContent[@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:formCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI asContent): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.38-2023-07-03T125606.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI asContent): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.3 eHDSIPackage (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('GRIC')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'GRIC'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.36
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]
Item: (eHDSI asSpecializedKind)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI asSpecializedKind): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="string(@classCode) = ('MMAT')">(eHDSI asSpecializedKind): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="count(hl7:code) &gt;= 1">(eHDSI asSpecializedKind): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.36-2022-12-09T143904.html"
              test="count(hl7:code) &lt;= 1">(eHDSI asSpecializedKind): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.36
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]/hl7:code
Item: (eHDSI asSpecializedKind)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.36
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:asSpecializedKind[@classCode = 'GRIC']/pharm:generalizedMaterialKind[@classCode = 'MMAT'][@determinerCode = 'KIND'][hl7:code]/hl7:name
Item: (eHDSI asSpecializedKind)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART']
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART']">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('PART')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@classCode">(eHDSI eP/eD Manufactured Material): attribute @classCode SHALL be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(eHDSI eP/eD Manufactured Material): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity
Item: (eHDSI ingredient)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(hl7:numerator) &lt;= 1">(eHDSI ingredient): element hl7:numerator appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(hl7:denominator) &lt;= 1">(eHDSI ingredient): element hl7:denominator appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity/hl7:numerator
Item: (eHDSI ingredient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity/hl7:denominator
Item: (eHDSI ingredient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI ingredient)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="string(@classCode) = ('MMAT')">(eHDSI ingredient): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI ingredient): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI ingredient): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI ingredient): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(pharm:name) &lt;= 1">(eHDSI ingredient): element pharm:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI ingredient)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI ingredient): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI ingredient): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.24 eHDSIActiveIngredient (DYNAMIC) or 1.3.6.1.4.1.12559.11.10.1.3.1.42.61 eHDSISubstance (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI ingredient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@classCode">(eHDSI eP/eD Manufactured Material): attribute @classCode SHALL be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(eHDSI eP/eD Manufactured Material): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity
Item: (eHDSI ingredient)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(hl7:numerator) &lt;= 1">(eHDSI ingredient): element hl7:numerator appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(hl7:denominator) &lt;= 1">(eHDSI ingredient): element hl7:denominator appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity/hl7:numerator
Item: (eHDSI ingredient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity/hl7:denominator
Item: (eHDSI ingredient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI ingredient)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="string(@classCode) = ('MMAT')">(eHDSI ingredient): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI ingredient): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI ingredient): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI ingredient): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(pharm:name) &lt;= 1">(eHDSI ingredient): element pharm:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI ingredient)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI ingredient): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI ingredient): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.24 eHDSIActiveIngredient (DYNAMIC) or 1.3.6.1.4.1.12559.11.10.1.3.1.42.61 eHDSISubstance (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI ingredient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@classCode">(eHDSI eP/eD Manufactured Material): attribute @classCode SHALL be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(eHDSI eP/eD Manufactured Material): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity
Item: (eHDSI ingredient)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(hl7:numerator) &lt;= 1">(eHDSI ingredient): element hl7:numerator appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(hl7:denominator) &lt;= 1">(eHDSI ingredient): element hl7:denominator appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity/hl7:numerator
Item: (eHDSI ingredient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:quantity/hl7:denominator
Item: (eHDSI ingredient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI ingredient)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="string(@classCode) = ('MMAT')">(eHDSI ingredient): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI ingredient): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI ingredient): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI ingredient): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="count(pharm:name) &lt;= 1">(eHDSI ingredient): element pharm:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI ingredient)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI ingredient): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.37-2024-04-11T135012.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI ingredient): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.24 eHDSIActiveIngredient (DYNAMIC) or 1.3.6.1.4.1.12559.11.10.1.3.1.42.61 eHDSISubstance (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.37
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:part[@classCode = 'PART'][pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:partProduct[@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:ingredient[@classCode]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI ingredient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('ACTI')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'ACTI'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:quantity[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:quantity[not(@nullFlavor)]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:quantity[not(@nullFlavor)]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(hl7:numerator) &gt;= 1">(eHDSI eP/eD Manufactured Material): element hl7:numerator is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(hl7:numerator) &lt;= 1">(eHDSI eP/eD Manufactured Material): element hl7:numerator appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(hl7:denominator) &gt;= 1">(eHDSI eP/eD Manufactured Material): element hl7:denominator is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(hl7:denominator) &lt;= 1">(eHDSI eP/eD Manufactured Material): element hl7:denominator appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:quantity[not(@nullFlavor)]/hl7:numerator
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:quantity[not(@nullFlavor)]/hl7:numerator">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI eP/eD Manufactured Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI eP/eD Manufactured Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@unit">(eHDSI eP/eD Manufactured Material): attribute @unit SHALL be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI eP/eD Manufactured Material): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@value">(eHDSI eP/eD Manufactured Material): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:quantity[not(@nullFlavor)]/hl7:denominator
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:quantity[not(@nullFlavor)]/hl7:denominator">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI eP/eD Manufactured Material): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI eP/eD Manufactured Material): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@unit">(eHDSI eP/eD Manufactured Material): attribute @unit SHALL be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="not(@unit) or (string-length(@unit) &gt; 0 and not(matches(@unit,'\s')))">(eHDSI eP/eD Manufactured Material): Attribute @unit SHALL be of data type 'cs'  - '<value-of select="@unit"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@value">(eHDSI eP/eD Manufactured Material): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@classCode) = ('MMAT')">(eHDSI eP/eD Manufactured Material): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="string(@determinerCode) = ('KIND')">(eHDSI eP/eD Manufactured Material): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="count(pharm:name) &lt;= 1">(eHDSI eP/eD Manufactured Material): element pharm:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI eP/eD Manufactured Material): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.24 eHDSIActiveIngredient (DYNAMIC) or 1.3.6.1.4.1.12559.11.10.1.3.1.42.61 eHDSISubstance (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:originalText
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:originalText">
      <extends rule="ED"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ED". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:originalText/hl7:reference
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:originalText/hl7:reference">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TEL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:translation
Item: (eHDSI eP/eD Manufactured Material)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]/hl7:translation">
      <extends rule="CD"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.30-2025-01-23T141901.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI eP/eD Manufactured Material): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.30
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]]/pharm:ingredientSubstance[pharm:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.24-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.61-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/pharm:name
Item: (eHDSI eP/eD Manufactured Material)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.29
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturerOrganization
Item: (eHDSI eP/eD Medication Information)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturerOrganization">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(eHDSI eP/eD Medication Information): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(eHDSI eP/eD Medication Information): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="@nullFlavor or hl7:id or hl7:name">(eHDSI eP/eD Medication Information): If the MarketingAuthorizationHolder or manufacturer Organization element is specified and doesn't have a nullFlavor value, an id or name element has to present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="count(hl7:name) &lt;= 1">(eHDSI eP/eD Medication Information): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.29
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturerOrganization/hl7:id
Item: (eHDSI eP/eD Medication Information)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturerOrganization/hl7:id">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI eP/eD Medication Information): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.29
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturerOrganization/hl7:name
Item: (eHDSI eP/eD Medication Information)
-->
   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[not(@nullFlavor)][@typeCode = 'REFR'][hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]/hl7:substanceAdministration[not(@nullFlavor)][@classCode = 'SBADM'][@moodCode = 'INT'][hl7:consumable]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturerOrganization/hl7:name">
      <extends rule="ON"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.29-2022-09-12T124637.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(eHDSI eP/eD Medication Information): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ON". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]]
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]]"
         id="d45e46723-false-d377389e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@typeCode) = ('COMP')">(epSOS CDA Supply): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]) &gt;= 1">(epSOS CDA Supply): element hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]) &lt;= 1">(epSOS CDA Supply): element hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]]/hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]]/hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]"
         id="d45e46741-false-d377411e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@classCode) = ('ACT')">(epSOS CDA Supply): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="string(@moodCode) = ('EVN')">(epSOS CDA Supply): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]) &gt;= 1">(epSOS CDA Supply): element hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="count(hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]) &lt;= 1">(epSOS CDA Supply): element hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.3
Context: *[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]]/hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]/hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]
Item: (epSOS CDA Supply)
-->

   <rule fpi="RULC-1"
         context="*[hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]]/hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.34'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.3'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.3']]/hl7:entryRelationship[hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]]/hl7:act[hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]]/hl7:code[(@code = 'SUBST' and @codeSystem = '2.16.840.1.113883.5.6') or @nullFlavor]"
         id="d45e46747-false-d377437e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.3-2019-11-11T141844.html"
              test="@nullFlavor or (@code='SUBST' and @codeSystem='2.16.840.1.113883.5.6')">(epSOS CDA Supply): The element value SHALL be one of 'code 'SUBST' codeSystem '2.16.840.1.113883.5.6''.</assert>
   </rule>
</pattern>
