<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Name: eHDSI Functional Status Organizer
Description: 
                 A functional status organizer collects functional status observations. 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317">
   <title>eHDSI Functional Status Organizer</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]"
         id="d45e73013-false-d389525e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]) &gt;= 1">(eHDSI Functional Status Organizer): element hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]) &lt;= 1">(eHDSI Functional Status Organizer): element hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]"
         id="d45e73042-false-d389548e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="string(@classCode) = ('CLUSTER')">(eHDSI Functional Status Organizer): The value for classCode SHALL be 'CLUSTER'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="string(@moodCode) = ('EVN')">(eHDSI Functional Status Organizer): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']) &gt;= 1">(eHDSI Functional Status Organizer): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']) &lt;= 1">(eHDSI Functional Status Organizer): element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(eHDSI Functional Status Organizer): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(eHDSI Functional Status Organizer): element hl7:id[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(eHDSI Functional Status Organizer): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(eHDSI Functional Status Organizer): element hl7:code[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(eHDSI Functional Status Organizer): element hl7:statusCode[@code = 'completed'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(eHDSI Functional Status Organizer): element hl7:statusCode[@code = 'completed'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:effectiveTime) &lt;= 1">(eHDSI Functional Status Organizer): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:component[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.40'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.13']]]) &gt;= 1">(eHDSI Functional Status Organizer): element hl7:component[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.40'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.13']]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &lt;= 1">(eHDSI Functional Status Organizer): element hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']"
         id="d45e73054-false-d389622e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Functional Status Organizer): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.3.39')">(eHDSI Functional Status Organizer): The value for root SHALL be '1.3.6.1.4.1.12559.11.10.1.3.1.3.39'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:id[not(@nullFlavor)]
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:id[not(@nullFlavor)]"
         id="d45e73062-false-d389636e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Functional Status Organizer): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:code[not(@nullFlavor)]
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:code[not(@nullFlavor)]"
         id="d45e73072-false-d389646e0">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Functional Status Organizer): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:statusCode[@code = 'completed']
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:statusCode[@code = 'completed']"
         id="d45e73081-false-d389657e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(eHDSI Functional Status Organizer): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="@nullFlavor or (@code='completed')">(eHDSI Functional Status Organizer): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:effectiveTime
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:effectiveTime"
         id="d45e73092-false-d389673e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(eHDSI Functional Status Organizer): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:IVL_TS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:component[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.40'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.13']]]
Item: (eHDSI Functional Status Organizer)
-->
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]"
         id="d45e73113-false-d389700e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="string(@typeCode) = ('REFR')">(eHDSI Functional Status Organizer): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &gt;= 1">(eHDSI Functional Status Organizer): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']"
         id="d45e73145-false-d389718e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="string(@classCode) = ('ACT')">(eHDSI Functional Status Organizer): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="string(@moodCode) = ('EVN')">(eHDSI Functional Status Organizer): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(eHDSI Functional Status Organizer): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(eHDSI Functional Status Organizer): element hl7:id[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.12559.11.10.1.3.1.3.39
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:id[not(@nullFlavor)]
Item: (eHDSI Functional Status Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.39']]/hl7:entryRelationship[@typeCode = 'REFR'][hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:id[not(@nullFlavor)]"
         id="d45e73151-false-d389742e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.12559.11.10.1.3.1.3.39-2025-05-08T154317.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Functional Status Organizer): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
</pattern>
