<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Name: Section Allergies and Other Adverse Reactions
Description: 
                 The adverse and other adverse reactions section shall contain a narrative description of the substance intolerances and the associated adverse reactions suffered by the patient. It shall include entries for intolerances and adverse reactions as described in the Entry Content Modules.  
                 The parent of this template is CCD 3.8. This template is compatible with the ASTM/HL7 Continuity of Care Document template: 2.16.840.1.113883.10.20.1.2  
                 The field "alerts" was originally defined to include all the important and objective medical information that should be highlighted (such as allergies, thrombosis risk, immune deficit …etc). When defining the content only allergies and intolerance to drugs appear to be the common understanding and the easiest to be transferred. A lot of surveys are being made in different
                    countries (not only in Europe) to make a more evidence-based definition of what should represented and should no
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934">
   <title>Section Allergies and Other Adverse Reactions</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]
Item: (Section Allergies and Other Adverse Reactions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]"
         id="d45e94364-false-d439892e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]) &gt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]) &lt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]
Item: (Section Allergies and Other Adverse Reactions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]"
         id="d45e94421-false-d439927e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Section Allergies and Other Adverse Reactions): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2']) &gt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2']) &lt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']) &gt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']) &lt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:id) &lt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:title[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:title[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:text[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Section Allergies and Other Adverse Reactions): element hl7:text[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2']
Item: (Section Allergies and Other Adverse Reactions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2']"
         id="d45e94425-false-d440003e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Section Allergies and Other Adverse Reactions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.1.2')">(Section Allergies and Other Adverse Reactions): The value for root SHALL be '2.16.840.1.113883.10.20.1.2'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']
Item: (Section Allergies and Other Adverse Reactions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']"
         id="d45e94433-false-d440018e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Section Allergies and Other Adverse Reactions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.5.3.1.3.13')">(Section Allergies and Other Adverse Reactions): The value for root SHALL be '1.3.6.1.4.1.19376.1.5.3.1.3.13'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:id
Item: (Section Allergies and Other Adverse Reactions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:id"
         id="d45e94441-false-d440032e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Section Allergies and Other Adverse Reactions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Section Allergies and Other Adverse Reactions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e94443-false-d440043e0">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Section Allergies and Other Adverse Reactions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="@nullFlavor or (@code='48765-2' and @codeSystem='2.16.840.1.113883.6.1')">(Section Allergies and Other Adverse Reactions): The element value SHALL be one of 'code '48765-2' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:title[not(@nullFlavor)]
Item: (Section Allergies and Other Adverse Reactions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:title[not(@nullFlavor)]"
         id="d45e94452-false-d440059e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Section Allergies and Other Adverse Reactions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:text[not(@nullFlavor)]
Item: (Section Allergies and Other Adverse Reactions)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:text[not(@nullFlavor)]"
         id="d45e94458-false-d440069e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-1.3.6.1.4.1.19376.1.5.3.1.3.13-2019-04-05T143934.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(Section Allergies and Other Adverse Reactions): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:SD.TEXT". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.5.3.1.3.13
Context: *[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.3.13']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.27'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.5.1'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.5.3']]]
Item: (Section Allergies and Other Adverse Reactions)
--></pattern>
