<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.11.10.153
Name: eHDSI Specimen Collection
Description: 
Specimen Collection is used when a set of laboratory or pathology observations  produced on one or more specimens need to be associated with the minimal characteristics of the specimen(s): specimen source site and type of specimen.
			     
In addition this template enables to convey when the specimen was collected.
			     
In a patient summary there is no need to provide more data than these 4:
			     
			   
				 collection method, 
                 
				 source site, 
                 
				 type of specimen and 
                 
				 time of collection. 
                 
			   
An occurrence of this template describes one specimen collected, used by the set of observations present in the same Result Organizer.
		
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959">
   <title>eHDSI Specimen Collection</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]
Item: (eHDSI Specimen Collection)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]"
         id="d45e124345-false-d460774e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="string(@classCode) = ('PROC')">(eHDSI Specimen Collection): The value for classCode SHALL be 'PROC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="string(@moodCode) = ('EVN')">(eHDSI Specimen Collection): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']) &gt;= 1">(eHDSI Specimen Collection): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']) &lt;= 1">(eHDSI Specimen Collection): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:code[(@code = '33882-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(eHDSI Specimen Collection): element hl7:code[(@code = '33882-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:effectiveTime) &lt;= 1">(eHDSI Specimen Collection): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:methodCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.94-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Specimen Collection): element hl7:methodCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.94-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:targetSiteCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.69-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Specimen Collection): element hl7:targetSiteCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.69-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:participant[@typeCode = 'PRD'][hl7:participantRole]) &lt;= 1">(eHDSI Specimen Collection): element hl7:participant[@typeCode = 'PRD'][hl7:participantRole] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']"
         id="d45e124351-false-d460837e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Specimen Collection): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.11.10.153')">(eHDSI Specimen Collection): The value for root SHALL be '2.16.840.1.113883.3.1937.777.11.10.153'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:code[(@code = '33882-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:code[(@code = '33882-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]"
         id="d45e124356-false-d460852e0">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Specimen Collection): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="@nullFlavor or (@code='33882-2' and @codeSystem='2.16.840.1.113883.6.1')">(eHDSI Specimen Collection): The element value SHALL be one of 'code '33882-2' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:effectiveTime
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:effectiveTime"
         id="d45e124364-false-d460868e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(eHDSI Specimen Collection): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:IVL_TS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:methodCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.94-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:methodCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.94-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d45e124371-false-d460881e0">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Specimen Collection): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.94-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Specimen Collection): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.94 eHDSISpecimenCollectionMethod (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:targetSiteCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.69-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:targetSiteCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.69-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d45e124376-false-d460904e0">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Specimen Collection): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.69-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Specimen Collection): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.69 eHDSIMorphologicAbnormality (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]"
         id="d45e124381-false-d460924e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="string(@typeCode) = ('PRD')">(eHDSI Specimen Collection): The value for typeCode SHALL be 'PRD'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &gt;= 1">(eHDSI Specimen Collection): element hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 1">(eHDSI Specimen Collection): element hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]"
         id="d45e124388-false-d460950e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="string(@classCode) = ('SPEC') or not(@classCode)">(eHDSI Specimen Collection): The value for classCode SHALL be 'SPEC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:id) &lt;= 1">(eHDSI Specimen Collection): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(eHDSI Specimen Collection): element hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(eHDSI Specimen Collection): element hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:id
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:id"
         id="d45e124392-false-d460979e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Specimen Collection): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d45e124394-false-d460992e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(eHDSI Specimen Collection): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(eHDSI Specimen Collection): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(eHDSI Specimen Collection): element hl7:code is coded with binding strength 'preferred' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(eHDSI Specimen Collection): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.153
Context: *[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (eHDSI Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]]/hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.153']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:playingEntity[hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d45e124400-false-d461022e0">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Specimen Collection): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.153-2025-05-13T114959.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.67-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Specimen Collection): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.67 eHDSILabSpecimenType (DYNAMIC)'.</assert>
   </rule>
</pattern>
