<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.11.10.154
Name: eHDSI Laboratory Result Observation
Description: This template constrains the results of a clinical laboratory observation. The result observation includes a statusCode to allow recording the status of an observation. “Pending” results (e.g., a test has been run but results have not been reported yet) should be represented as “active” ActStatus.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558">
   <title>eHDSI Laboratory Result Observation</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]
Item: (eHDSI Laboratory Result Observation)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]"
         id="d45e124625-false-d461933e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="string(@classCode) = ('OBS')">(eHDSI Laboratory Result Observation): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="string(@moodCode) = ('EVN')">(eHDSI Laboratory Result Observation): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']) &gt;= 1">(eHDSI Laboratory Result Observation): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.70-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(eHDSI Laboratory Result Observation): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.70-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.70-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.70-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.19890-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &gt;= 1">(eHDSI Laboratory Result Observation): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.19890-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.19890-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.19890-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:effectiveTime) &gt;= 1">(eHDSI Laboratory Result Observation): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:effectiveTime) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[@xsi:type='CS'] | hl7:value[@xsi:type='PQ'] | hl7:value[@xsi:type='IVL_PQ'] | hl7:value[@xsi:type='ST'] | hl7:value[@xsi:type='TS'] | hl7:value[@xsi:type='RTO_QTY_QTY']) &gt;= 1">(eHDSI Laboratory Result Observation): choice (hl7:value[@xsi:type='CS']  or  hl7:value[@xsi:type='PQ']  or  hl7:value[@xsi:type='IVL_PQ']  or  hl7:value[@xsi:type='ST']  or  hl7:value[@xsi:type='TS']  or  hl7:value[@xsi:type='RTO_QTY_QTY']) does not contain enough elements [min 1x]</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[@xsi:type='CS'] | hl7:value[@xsi:type='PQ'] | hl7:value[@xsi:type='IVL_PQ'] | hl7:value[@xsi:type='ST'] | hl7:value[@xsi:type='TS'] | hl7:value[@xsi:type='RTO_QTY_QTY']) &lt;= 1">(eHDSI Laboratory Result Observation): choice (hl7:value[@xsi:type='CS']  or  hl7:value[@xsi:type='PQ']  or  hl7:value[@xsi:type='IVL_PQ']  or  hl7:value[@xsi:type='ST']  or  hl7:value[@xsi:type='TS']  or  hl7:value[@xsi:type='RTO_QTY_QTY']) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[@xsi:type='CS']) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:value[@xsi:type='CS'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[@xsi:type='PQ']) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:value[@xsi:type='PQ'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[@xsi:type='IVL_PQ']) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:value[@xsi:type='IVL_PQ'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[@xsi:type='ST']) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:value[@xsi:type='ST'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[@xsi:type='TS']) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:value[@xsi:type='TS'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[@xsi:type='RTO_QTY_QTY']) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:value[@xsi:type='RTO_QTY_QTY'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:referenceRange[hl7:observationRange]) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:referenceRange[hl7:observationRange] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']"
         id="d45e124628-false-d462065e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.11.10.154')">(eHDSI Laboratory Result Observation): The value for root SHALL be '2.16.840.1.113883.3.1937.777.11.10.154'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:id
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:id"
         id="d45e124630-false-d462079e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.70-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.70-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d45e124631-false-d462092e0">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.70-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Laboratory Result Observation): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.70 eHDSILabCode (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.19890-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.19890-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]"
         id="d45e124633-false-d462115e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.19890-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(eHDSI Laboratory Result Observation): The element value SHALL be one of '2.16.840.1.113883.1.11.19890 x_ActStatusActiveComplete (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:effectiveTime
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:effectiveTime"
         id="d45e124635-false-d462135e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:IVL_TS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='CS']
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='CS']"
         id="d45e124637-false-d462143e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.20-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem) or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.77-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem) or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.78-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(eHDSI Laboratory Result Observation): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.20 eHDSIBloodGroup (DYNAMIC) or 1.3.6.1.4.1.12559.11.10.1.3.1.42.77 eHDSIPresenceAbsence (DYNAMIC) or 1.3.6.1.4.1.12559.11.10.1.3.1.42.78 eHDSIMicroorganism (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='PQ']
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='PQ']"
         id="d45e124649-false-d462173e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI Laboratory Result Observation): @value is not a valid PQ number <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(eHDSI Laboratory Result Observation): value/@unit (PQ) SHALL be a valid UCUM unit (<value-of select="$UCUMtest"/>).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='IVL_PQ']
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='IVL_PQ']"
         id="d45e124656-false-d462186e0">
      <extends rule="IVL_PQ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_PQ')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:IVL_PQ". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="not(hl7:low/@value) or matches(string(hl7:low/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI Laboratory Result Observation): value/low @value is not a valid PQ number<value-of select="hl7:low/@value"/>
      </assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="not(hl7:high/@value) or matches(string(hl7:high/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI Laboratory Result Observation): value/high @value is not a valid PQ number<value-of select="hl7:high/@value"/>
      </assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="not(hl7:center/@value) or matches(string(hl7:center/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(eHDSI Laboratory Result Observation): value/center @value is not a valid PQ number<value-of select="hl7:center/@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='ST']
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='ST']"
         id="d45e124666-false-d462201e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ST". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='TS']
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='TS']"
         id="d45e124672-false-d462209e0">
      <extends rule="TS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="not(*)">(eHDSI Laboratory Result Observation): <value-of select="local-name()"/> with datatype TS, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='RTO_QTY_QTY']
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:value[@xsi:type='RTO_QTY_QTY']"
         id="d45e124677-false-d462220e0">
      <extends rule="RTO_QTY_QTY"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'RTO_QTY_QTY')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:RTO_QTY_QTY". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d45e124687-false-d462233e0">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Laboratory Result Observation): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.73 eHDSIObservationInterpretation (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.151']
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.151']"
         id="d462234e27-false-d462255e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Body Author): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.11.10.151')">(eHDSI Body Author): The value for root SHALL be '2.16.840.1.113883.3.1937.777.11.10.151'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:time
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:time"
         id="d462234e32-false-d462269e0">
      <extends rule="TS.EPSOS.TZ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(eHDSI Body Author): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="not(*)">(eHDSI Body Author): <value-of select="local-name()"/> with datatype TS.EPSOS.TZ, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]"
         id="d462234e34-false-d462287e0">
      <extends rule="ANY"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="count(hl7:id) &gt;= 1">(eHDSI Body Author): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="count(hl7:code) &lt;= 1">(eHDSI Body Author): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(eHDSI Body Author): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="count(hl7:assignedPerson) &lt;= 1">(eHDSI Body Author): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="count(hl7:assignedAuthoringDevice) &lt;= 1">(eHDSI Body Author): element hl7:assignedAuthoringDevice appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="count(hl7:representedOrganization) &lt;= 1">(eHDSI Body Author): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id"
         id="d462234e36-false-d462345e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Body Author): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:code
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:code"
         id="d462234e38-false-d462355e0">
      <extends rule="ANY"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson"
         id="d462234e42-false-d462363e0">
      <extends rule="ANY"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice
Item: (eHDSI Body Author)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.129
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice
Item: (eHDSI Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.129-2025-10-13T160900.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(eHDSI Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.129-2025-10-13T160900.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(eHDSI Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.129-2025-10-13T160900.html"
              test="count(hl7:code) &lt;= 1">(eHDSI Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.129-2025-10-13T160900.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(eHDSI Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.129-2025-10-13T160900.html"
              test="count(hl7:softwareName) &lt;= 1">(eHDSI Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.129
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice/hl7:code
Item: (eHDSI Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice/hl7:code">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.129-2025-10-13T160900.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Device): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.129-2025-10-13T160900.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(eHDSI Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.129
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (eHDSI Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice/hl7:manufacturerModelName">
      <extends rule="SC"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.129-2025-10-13T160900.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SC')">(eHDSI Device): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:SC". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.129
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (eHDSI Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice/hl7:softwareName">
      <extends rule="SC"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.129-2025-10-13T160900.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SC')">(eHDSI Device): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:SC". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization"
         id="d462234e47-false-d462471e0">
      <extends rule="ANY"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization/hl7:id
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization/hl7:id"
         id="d462234e49-false-d462494e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Body Author): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization/hl7:name
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization/hl7:name"
         id="d462234e51-false-d462504e0">
      <extends rule="ANY"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization/hl7:telecom
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization/hl7:telecom"
         id="d462234e53-false-d462512e0">
      <extends rule="TEL.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(eHDSI Body Author): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TEL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.151
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization/hl7:addr
Item: (eHDSI Body Author)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization/hl7:addr"
         id="d462234e55-false-d462522e0">
      <extends rule="AD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.151-2022-07-12T111350.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(eHDSI Body Author): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:AD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]"
         id="d45e124690-false-d462532e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:observationRange[not(@nullFlavor)]) &gt;= 1">(eHDSI Laboratory Result Observation): element hl7:observationRange[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:observationRange[not(@nullFlavor)]) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:observationRange[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]/hl7:observationRange[not(@nullFlavor)]
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]/hl7:observationRange[not(@nullFlavor)]"
         id="d45e124693-false-d462548e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.74-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.75-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) = 0">(eHDSI Laboratory Result Observation): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.74-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.75-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] MAY NOT be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[not(@nullFlavor)]) &gt;= 1">(eHDSI Laboratory Result Observation): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:value[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="count(hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(eHDSI Laboratory Result Observation): element hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]/hl7:observationRange[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.74-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.75-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]/hl7:observationRange[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.74-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.75-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d45e124694-false-d462589e0">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.74-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.75-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Laboratory Result Observation): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.74 eHDSIReferenceRangeMeaning (DYNAMIC) or 1.3.6.1.4.1.12559.11.10.1.3.1.42.75 eHDSIReferenceRangeAppliesTo (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]/hl7:observationRange[not(@nullFlavor)]/hl7:value[not(@nullFlavor)]
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]/hl7:observationRange[not(@nullFlavor)]/hl7:value[not(@nullFlavor)]"
         id="d45e124697-false-d462615e0">
      <extends rule="ANY"/>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]/hl7:observationRange[not(@nullFlavor)]/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (eHDSI Laboratory Result Observation)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:referenceRange[hl7:observationRange]/hl7:observationRange[not(@nullFlavor)]/hl7:interpretationCode[concat(@code, @codeSystem) = doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d45e124698-false-d462626e0">
      <extends rule="CE.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(eHDSI Laboratory Result Observation): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CE". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="@nullFlavor or exists(doc('include/voc-1.3.6.1.4.1.12559.11.10.1.3.1.42.73-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(eHDSI Laboratory Result Observation): The element value SHALL be one of '1.3.6.1.4.1.12559.11.10.1.3.1.42.73 eHDSIObservationInterpretation (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.154
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]
Item: (eHDSI Laboratory Result Observation)
-->
   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.154']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.154-2025-05-13T141558.html"
              test="string(@typeCode) = ('COMP')">(eHDSI Laboratory Result Observation): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
