<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.11.10.155
Name: eHDSI Comment Activity
Description: Comments are free text data that cannot otherwise be recorded using data elements already defined by this specification. They are not to be used to record information that can be recorded elsewhere. For example, a free text description of the severity of an allergic reaction would not be recorded in a comment.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950">
   <title>eHDSI Comment Activity</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]
Item: (eHDSI Comment Activity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]"
         id="d45e124743-false-d462683e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="string(@classCode) = ('ACT')">(eHDSI Comment Activity): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="string(@moodCode) = ('EVN')">(eHDSI Comment Activity): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']) &gt;= 1">(eHDSI Comment Activity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']) &lt;= 1">(eHDSI Comment Activity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(eHDSI Comment Activity): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(eHDSI Comment Activity): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(eHDSI Comment Activity): element hl7:text[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(eHDSI Comment Activity): element hl7:text[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:author[hl7:assignedAuthor]) &lt;= 1">(eHDSI Comment Activity): element hl7:author[hl7:assignedAuthor] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']"
         id="d45e124749-false-d462732e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Comment Activity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.11.10.155')">(eHDSI Comment Activity): The value for root SHALL be '2.16.840.1.113883.3.1937.777.11.10.155'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e124754-false-d462747e0">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(eHDSI Comment Activity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="@nullFlavor or (@code='48767-8' and @codeSystem='2.16.840.1.113883.6.1')">(eHDSI Comment Activity): The element value SHALL be one of 'code '48767-8' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:text[not(@nullFlavor)]
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:text[not(@nullFlavor)]"
         id="d45e124759-false-d462763e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(eHDSI Comment Activity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:ED". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(eHDSI Comment Activity): element hl7:reference[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(eHDSI Comment Activity): element hl7:reference[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:text[not(@nullFlavor)]/hl7:reference[not(@nullFlavor)]
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:text[not(@nullFlavor)]/hl7:reference[not(@nullFlavor)]"
         id="d45e124761-false-d462782e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(eHDSI Comment Activity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TEL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="@value">(eHDSI Comment Activity): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="not(@value) or string(@value castable as xs:anyURI)">(eHDSI Comment Activity): Attribute @value SHALL be of data type 'url'  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="not(@value) or starts-with(@value, '#')">(eHDSI Comment Activity): This reference/@value SHALL begin with a '#' and SHALL point to its corresponding narrative (using the approach defined in CDA Release 2, section 4.3.5.1)</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]"
         id="d45e124771-false-d462798e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:time) &gt;= 1">(eHDSI Comment Activity): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:time) &lt;= 1">(eHDSI Comment Activity): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &gt;= 1">(eHDSI Comment Activity): element hl7:assignedAuthor[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &lt;= 1">(eHDSI Comment Activity): element hl7:assignedAuthor[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:time"
         id="d45e124773-false-d462822e0">
      <extends rule="TS.IPS.TZ"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(eHDSI Comment Activity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:TS". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="not(*)">(eHDSI Comment Activity): <value-of select="local-name()"/> with datatype TS.IPS.TZ, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]"
         id="d45e124775-false-d462835e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:id) &gt;= 1">(eHDSI Comment Activity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:id) &lt;= 1">(eHDSI Comment Activity): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:addr[not(@nullFlavor)]) &gt;= 1">(eHDSI Comment Activity): element hl7:addr[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &gt;= 1">(eHDSI Comment Activity): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) does not contain enough elements [min 1x]</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(eHDSI Comment Activity): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:assignedPerson) &lt;= 1">(eHDSI Comment Activity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:assignedAuthoringDevice) &lt;= 1">(eHDSI Comment Activity): element hl7:assignedAuthoringDevice appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id"
         id="d45e124777-false-d462881e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(eHDSI Comment Activity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:II". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]"
         id="d45e124779-false-d462891e0">
      <extends rule="AD"/>
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'AD')">(eHDSI Comment Activity): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:AD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson
Item: (eHDSI Comment Activity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson/hl7:name
Item: (eHDSI Comment Activity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice
Item: (eHDSI Comment Activity)
-->

   <rule fpi="RULC-1"
         context="*[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice"
         id="d45e124788-false-d462920e0">
      <assert role="error"
              see="https://art-decor.ehdsi.eu/publication/epsos-html-20260211T104851/tmp-2.16.840.1.113883.3.1937.777.11.10.155-2025-05-13T142950.html"
              test="count(hl7:softwareName) &lt;= 1">(eHDSI Comment Activity): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.11.10.155
Context: *[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.11.10.155']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (eHDSI Comment Activity)
-->
</pattern>
